# Two optimal policy levels to reach the first-best levels of social interactions and capital
# with data, estimates, and first best results from schools of size between 4 and 50

# Import packages
import os, sys
import numpy as np
import pandas as pd
import pickle, math
import random 
import scipy.optimize
from scipy.optimize import NonlinearConstraint

# social-interaction subsidy objective function
def welfare_subsidy_SI(sigm,DIJ,Thetaij,nij_o,s_o):
    beta=th[1:23]
    alpha=th[23:24]
    c=abs(th[24:25])
    beta0=th[0:1]
    N=DIJ.shape[0]
    A=(np.ones((N,N))-np.identity(N))*beta0 
    if np.amax(np.linalg.eig(A)[0])>alpha/N:
        DI=np.identity(N)-(alpha/N)*A+Thetaij
        s=np.matmul( np.linalg.inv(DI), (1+alpha*sigm)*np.ones((N,1))-(c*alpha/N)*np.matmul(DIJ,np.ones((N,1))))
        nij=beta0*(np.ones((N,N))-np.identity(N))+(sigm*(np.ones((N,N))-np.identity(N))-c*DIJ)/np.outer(np.ones((N,1)),s)+Thetaij
        Fsub=np.sum(np.sum( (((beta0+Thetaij)*nij-nij*nij/2) * np.outer(np.ones((N,1)),s)) -c*nij*DIJ +(sigm)*nij))
        Fopt=np.sum(np.sum( (((beta0+Thetaij)*nij_o-nij_o*nij_o/2) * np.outer(np.ones((N,1)),s_o)) -c*nij_o*DIJ))
        F=(Fopt-Fsub)**2
    else:
        F=np.inf
    return F

# transporation subsidy objective function
def welfare_subsidy_TA(tau,DIJ,Thetaij,nij_o,s_o):
    beta=th[1:23]
    alpha=th[23:24]
    c=abs(th[24:25])
    beta0=th[0:1]
    N=DIJ.shape[0]
    A=(np.ones((N,N))-np.identity(N))*beta0 
    if np.amax(np.linalg.eig(A)[0])>alpha/N:
        DI=np.identity(N)-(alpha/N)*A+Thetaij
        s=np.matmul( np.linalg.inv(DI), np.ones((N,1))-(c*(1-tau)*alpha/N)*np.matmul(DIJ,np.ones((N,1))))
        nij=beta0*(np.ones((N,N))-np.identity(N))-c*(1-tau)*DIJ/np.outer(np.ones((N,1)),s)+Thetaij
        Fsub=np.sum(np.sum( (((beta0+Thetaij)*nij-nij*nij/2) * np.outer(np.ones((N,1)),s)) -(1-tau)*c*nij*DIJ ))
        Fopt=np.sum(np.sum( (((beta0+Thetaij)*nij_o-nij_o*nij_o/2) * np.outer(np.ones((N,1)),s_o)) -c*nij_o*DIJ))
        F=(Fopt-Fsub)**2
    else:
        F=np.inf
    return F

if __name__ == '__main__':

    # Load the data
    with open('spatial_interaction_finaldata_schools4to50.pkl','rb') as f:
        Data=pickle.load(f)
    with open('Xdata_pair_level_Schools4to50.pkl','rb') as f:
        xdata=pickle.load(f)
    with open('II_Results_Schools4to50.pkl','rb') as f:
        Result=pickle.load(f)
    th=Result[0]
    beta=th[1:23]
    alpha=th[23:24]
    c=abs(th[24:25])
    beta0=th[0:1]
    sig=th[25:26] 
    with open('OPT_OBS_RESULT_LIST.pkl','rb') as f:
        Result_LIST=pickle.load(f)
    NIJ_OPT=Result_LIST[0] 
    S2_OPT=Result_LIST[4] 
    Scell=Data[0]
    SDcell=Data[1]
    Xcell1=Data[2]
    Xcell2=Data[3]
    D=Data[4]
    EPcell=Data[5]
    st_list=Data[6]
    GE=Data[7]
    ADcell=Data[9]
    H=len(Scell) 
    Xcell=[] 
    k1=Xcell1[0].shape[2] 
    for h in range(1,H+1):
        Xcell.append(abs(Xcell1[h-1]))
    R=100 
    K=k1*2 
    XBc=[]
    for h in range(1,H+1):
        DIJ=D[h-1]
        N=DIJ.shape[0]
        Xarray1=np.zeros((N,N,K))
        Xarray2=np.zeros((N,N,K))
        X1=Xcell1[h-1]
        X2=Xcell2[h-1]
        for k in range(1,k1+1):
            Xarray1[:,:,k-1]=X1[:,:,k-1]*beta[k-1]
            Xarray2[:,:,k-1]=X2[:,:,k-1]*beta[k1+k-1]
        XBc.append(np.sum(Xarray1,axis=2)+np.sum(Xarray2,axis=2)+(np.ones((N,N))-np.identity(N))*beta0)

    # Start policy simulations 
    Nstat001=np.zeros((H,R))
    Nstat002=np.zeros((H,R))
    Dstat=np.zeros((H,1))
    SIG=np.zeros((H,R))
    TAU=np.zeros((H,R))
    bnds=np.zeros((1,2))
    bnds[0,1]=np.inf
    x1=np.array([0.1])
    bnds2=np.zeros((1,2))
    bnds2[0,1]=1
    for r in range(1,R+1):
        NIJ2_o=NIJ_OPT[r-1]
        S2r_OPT=S2_OPT[r-1]
        for h in range(1,H+1):
            np.random.seed(1000*r+h) 
            DIJ=D[h-1]
            N=DIJ.shape[0]
            ERR=sig*np.random.standard_normal((N,N))
            Thetaij=XBc[h-1]+ERR-(np.ones((N,N))-np.identity(N))*beta0
            XBij=XBc[h-1] 
            A=SDcell[h-1]
            F=ADcell[h-1] 
            # FIXED POINTS
            DI=np.identity(N)-(alpha/N)*(Thetaij+(np.ones((N,N))-np.identity(N))*beta0) 
            s_star=np.matmul(np.matmul(np.linalg.inv(DI),(np.identity(N)-alpha*c*DIJ)),np.ones((N,1)))
            # Social-interaction policy
            nij_o=NIJ2_o[h-1]
            s_o=S2r_OPT[h-1]
            pol12=scipy.optimize.minimize(welfare_subsidy_SI,x1,args=(DIJ,Thetaij,nij_o,s_o),bounds=bnds)
            sigma2=pol12.x
            # Transportation policy
            pol22=scipy.optimize.minimize(welfare_subsidy_TA,x1,args=(DIJ,Thetaij,nij_o,s_o),bounds=bnds2)
            tau2=pol22.x
            # Calculating social interaction and social capital under each policy
            ss11=np.matmul(np.linalg.inv(np.identity(N)-(alpha/N)*(np.ones((N,N))-np.identity(N))*beta0), (1+alpha*sigma2)*np.ones((N,1))-(c*alpha/N)*np.matmul(DIJ,np.ones((N,1))))
            nijs1=beta0*(np.ones((N,N))-np.identity(N))+(sigma2*(np.ones((N,N))-np.identity(N))-c*DIJ)/np.outer(np.ones((N,1)),ss11)+Thetaij
            ss21=np.matmul(np.linalg.inv(np.identity(N)-(alpha/N)*(np.ones((N,N))-np.identity(N))*beta0), np.ones((N,1))-(c*(1-tau2)*alpha/N)*np.matmul(DIJ,np.ones((N,1))))
            nijs2=beta0*(np.ones((N,N))-np.identity(N))-c*(1-tau2)*DIJ/np.outer(np.ones((N,1)),ss21)+Thetaij
            nijs01=nijs1*(nijs1>0) # ensure nonnegative social interactions
            nijs02=nijs2*(nijs2>0) # ensure nonnegative social interactions
            # Store results
            SIG[h-1,r-1]=sigma2
            TAU[h-1,r-1]=tau2
            Nstat001[h-1,r-1]=np.sum(np.sum(nijs01))/(N*(N-1)) # pol1
            Nstat002[h-1,r-1]=np.sum(np.sum(nijs02))/(N*(N-1)) # pol1
            Dstat[h-1,0]=np.sum(np.sum(DIJ))/(N*(N-1))
            
    # Save results
    Result_stats=[Nstat001,Nstat002,Dstat,SIG,TAU]
    with open('Pol_to_opt_results_schools4to50.pkl','wb') as f:
        pickle.dump(Result_stats,f)
    # Results (as Table 8)
    TB=np.zeros((2,6))
    TB[0,0]=np.mean(np.mean(SIG,axis=0)) 
    TB[0,3]=np.mean(np.mean(TAU,axis=0)) 
    TB[1,0]=np.std(np.mean(SIG,axis=0)) 
    TB[1,3]=np.std(np.mean(TAU,axis=0)) 
    TB[0,1]=np.min(np.mean(SIG,axis=0)) 
    TB[0,2]=np.max(np.mean(SIG,axis=0)) 
    TB[0,4]=np.min(np.mean(TAU,axis=0)) 
    TB[0,5]=np.max(np.mean(TAU,axis=0)) 
    TB[1,1]=np.quantile(np.mean(SIG,axis=0),0.05) 
    TB[1,2]=np.quantile(np.mean(SIG,axis=0),0.95) 
    TB[1,4]=np.quantile(np.mean(TAU,axis=0),0.05) 
    TB[1,5]=np.quantile(np.mean(TAU,axis=0),0.95) 
    with open('Pol_to_opt_table_schools4to50.pkl','wb') as f:
        pickle.dump(TB,f)
